﻿using System;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.Mvi.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Mvi.PipelineSteps.ProxyAdd
{
    /// <summary>
    /// Get the Patients step.
    /// </summary>
    public class GetVeteranStep : FilterBase<ProxyAddStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(ProxyAddStateObject state)
        {
            var vet = state.OrganizationServiceProxy.Retrieve(Contact.EntityLogicalName, state.VeteranPartyId, new Microsoft.Xrm.Sdk.Query.ColumnSet(true));
            if (vet == null) throw new Exception("Veteran could not be found: " + state.VeteranPartyId);
            state.Veteran = vet.ToEntity<Contact>();
            
        }
    }
}